package gov.va.med.mhv.sm.admin.enums;

public enum RelationTypeEnum {

	PRIMARY_PROVIDER (0L, "primary provider"),
	CLINIC (1L, "clinic"),
	TEAM (2L, "team"),
	FACILITY (3L, "facility"),
	VISN (4L, "visn"),
	GLOBAL(5L, "global"),
	PATIENT(6L, "patient");
	
	private Long id;
	private String description;
	
	private RelationTypeEnum(Long id, String description){
		this.id = id;
		this.description = description;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	
	public static RelationTypeEnum valueOf(Long value){
		for(RelationTypeEnum f : RelationTypeEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no relation type found");
	}
	
}
